/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.AnnotationDefault;
import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Annotations;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.BootstrapMethods;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantDynamic;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantInvokeDynamic;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodHandle;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodType;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantModule;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPackage;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.Deprecated;
import com.sun.org.apache.bcel.internal.classfile.EnclosingMethod;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.InnerClass;
import com.sun.org.apache.bcel.internal.classfile.InnerClasses;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTypeTable;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.MethodParameters;
import com.sun.org.apache.bcel.internal.classfile.ParameterAnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.ParameterAnnotations;
import com.sun.org.apache.bcel.internal.classfile.Signature;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.StackMap;
import com.sun.org.apache.bcel.internal.classfile.StackMapEntry;
import com.sun.org.apache.bcel.internal.classfile.Synthetic;
import com.sun.org.apache.bcel.internal.classfile.Unknown;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.util.Stack;

public class DescendingVisitor
implements Visitor {
    private final JavaClass clazz;
    private final Visitor visitor;
    private final Stack<Object> stack = new Stack();

    public Object predecessor() {
        return this.predecessor(0);
    }

    public Object predecessor(int level) {
        int size = this.stack.size();
        if (size < 2 || level < 0) {
            return null;
        }
        return this.stack.elementAt(size - (level + 2));
    }

    public Object current() {
        return this.stack.peek();
    }

    public DescendingVisitor(JavaClass clazz, Visitor visitor) {
        this.clazz = clazz;
        this.visitor = visitor;
    }

    public void visit() {
        this.clazz.accept(this);
    }

    @Override
    public void visitJavaClass(JavaClass _clazz) {
        Attribute[] attributes;
        Method[] methods;
        Field[] fields;
        this.stack.push(_clazz);
        _clazz.accept(this.visitor);
        for (Field field : fields = _clazz.getFields()) {
            field.accept(this);
        }
        for (Method method : methods = _clazz.getMethods()) {
            method.accept(this);
        }
        for (Attribute attribute : attributes = _clazz.getAttributes()) {
            attribute.accept(this);
        }
        _clazz.getConstantPool().accept(this);
        this.stack.pop();
    }

    @Override
    public void visitAnnotation(Annotations annotation) {
        AnnotationEntry[] entries;
        this.stack.push(annotation);
        annotation.accept(this.visitor);
        for (AnnotationEntry entrie : entries = annotation.getAnnotationEntries()) {
            entrie.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitAnnotationEntry(AnnotationEntry annotationEntry) {
        this.stack.push(annotationEntry);
        annotationEntry.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitField(Field field) {
        Attribute[] attributes;
        this.stack.push(field);
        field.accept(this.visitor);
        for (Attribute attribute : attributes = field.getAttributes()) {
            attribute.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitConstantValue(ConstantValue cv) {
        this.stack.push(cv);
        cv.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitMethod(Method method) {
        Attribute[] attributes;
        this.stack.push(method);
        method.accept(this.visitor);
        for (Attribute attribute : attributes = method.getAttributes()) {
            attribute.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitExceptionTable(ExceptionTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitCode(Code code) {
        Attribute[] attributes;
        CodeException[] table;
        this.stack.push(code);
        code.accept(this.visitor);
        for (CodeException element : table = code.getExceptionTable()) {
            element.accept(this);
        }
        for (Attribute attribute : attributes = code.getAttributes()) {
            attribute.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitCodeException(CodeException ce) {
        this.stack.push(ce);
        ce.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLineNumberTable(LineNumberTable table) {
        LineNumber[] numbers;
        this.stack.push(table);
        table.accept(this.visitor);
        for (LineNumber number : numbers = table.getLineNumberTable()) {
            number.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitLineNumber(LineNumber number) {
        this.stack.push(number);
        number.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariableTable(LocalVariableTable table) {
        LocalVariable[] vars;
        this.stack.push(table);
        table.accept(this.visitor);
        for (LocalVariable var : vars = table.getLocalVariableTable()) {
            var.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitStackMap(StackMap table) {
        StackMapEntry[] vars;
        this.stack.push(table);
        table.accept(this.visitor);
        for (StackMapEntry var : vars = table.getStackMap()) {
            var.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitStackMapEntry(StackMapEntry var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariable(LocalVariable var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantPool(ConstantPool cp) {
        this.stack.push(cp);
        cp.accept(this.visitor);
        Constant[] constants = cp.getConstantPool();
        for (int i = 1; i < constants.length; ++i) {
            if (constants[i] == null) continue;
            constants[i].accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitConstantClass(ConstantClass constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantDouble(ConstantDouble constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantFieldref(ConstantFieldref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantFloat(ConstantFloat constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInteger(ConstantInteger constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInvokeDynamic(ConstantInvokeDynamic constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantLong(ConstantLong constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodref(ConstantMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantNameAndType(ConstantNameAndType constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantString(ConstantString constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantUtf8(ConstantUtf8 constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitInnerClasses(InnerClasses ic) {
        InnerClass[] ics;
        this.stack.push(ic);
        ic.accept(this.visitor);
        for (InnerClass ic2 : ics = ic.getInnerClasses()) {
            ic2.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitInnerClass(InnerClass inner) {
        this.stack.push(inner);
        inner.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitBootstrapMethods(BootstrapMethods bm) {
        this.stack.push(bm);
        bm.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitDeprecated(Deprecated attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSignature(Signature attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSourceFile(SourceFile attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSynthetic(Synthetic attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitUnknown(Unknown attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitAnnotationDefault(AnnotationDefault obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitEnclosingMethod(EnclosingMethod obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariableTypeTable(LocalVariableTypeTable obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitParameterAnnotation(ParameterAnnotations obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitMethodParameters(MethodParameters obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodType(ConstantMethodType obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodHandle(ConstantMethodHandle obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitParameterAnnotationEntry(ParameterAnnotationEntry obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantPackage(ConstantPackage obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantModule(ConstantModule obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantDynamic(ConstantDynamic obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }
}

