/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jdk.internal.event.EventHelper;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.ParsingException;
import sun.security.provider.certpath.X509CertPath;
import sun.security.provider.certpath.X509CertificatePair;
import sun.security.util.Cache;
import sun.security.util.KeyUtil;
import sun.security.util.Pem;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;

public class X509Factory
extends CertificateFactorySpi {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    private static final int ENC_MAX_LENGTH = 0x400000;
    private static final Cache<Object, X509CertImpl> certCache = Cache.newSoftMemoryCache(750);
    private static final Cache<Object, X509CRLImpl> crlCache = Cache.newSoftMemoryCache(750);

    @Override
    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            certCache.clear();
            X509CertificatePair.clearCache();
            throw new CertificateException("Missing input stream");
        }
        try {
            byte[] byArray = X509Factory.readOneBlock(inputStream);
            if (byArray != null) {
                X509CertImpl x509CertImpl = X509Factory.getFromCache(certCache, byArray);
                if (x509CertImpl != null) {
                    return x509CertImpl;
                }
                x509CertImpl = new X509CertImpl(byArray);
                X509Factory.addToCache(certCache, x509CertImpl.getEncodedInternal(), x509CertImpl);
                this.recordEvent(x509CertImpl);
                return x509CertImpl;
            }
            throw new IOException("Empty input");
        }
        catch (IOException iOException) {
            throw new CertificateException("Could not parse certificate: " + iOException.toString(), iOException);
        }
    }

    private static int readFully(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, int n) throws IOException {
        int n2;
        int n3 = 0;
        byte[] byArray = new byte[2048];
        while (n > 0 && (n2 = inputStream.read(byArray, 0, n < 2048 ? n : 2048)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
            n3 += n2;
            n -= n2;
        }
        return n3;
    }

    public static synchronized X509CertImpl intern(X509Certificate x509Certificate) throws CertificateException {
        if (x509Certificate == null) {
            return null;
        }
        boolean bl = x509Certificate instanceof X509CertImpl;
        byte[] byArray = bl ? ((X509CertImpl)x509Certificate).getEncodedInternal() : x509Certificate.getEncoded();
        X509CertImpl x509CertImpl = X509Factory.getFromCache(certCache, byArray);
        if (x509CertImpl != null) {
            return x509CertImpl;
        }
        if (bl) {
            x509CertImpl = (X509CertImpl)x509Certificate;
        } else {
            x509CertImpl = new X509CertImpl(byArray);
            byArray = x509CertImpl.getEncodedInternal();
        }
        X509Factory.addToCache(certCache, byArray, x509CertImpl);
        return x509CertImpl;
    }

    public static synchronized X509CRLImpl intern(X509CRL x509CRL) throws CRLException {
        if (x509CRL == null) {
            return null;
        }
        boolean bl = x509CRL instanceof X509CRLImpl;
        byte[] byArray = bl ? ((X509CRLImpl)x509CRL).getEncodedInternal() : x509CRL.getEncoded();
        X509CRLImpl x509CRLImpl = X509Factory.getFromCache(crlCache, byArray);
        if (x509CRLImpl != null) {
            return x509CRLImpl;
        }
        if (bl) {
            x509CRLImpl = (X509CRLImpl)x509CRL;
        } else {
            x509CRLImpl = new X509CRLImpl(byArray);
            byArray = x509CRLImpl.getEncodedInternal();
        }
        X509Factory.addToCache(crlCache, byArray, x509CRLImpl);
        return x509CRLImpl;
    }

    private static synchronized <K, V> V getFromCache(Cache<K, V> cache, byte[] byArray) {
        Cache.EqualByteArray equalByteArray = new Cache.EqualByteArray(byArray);
        return cache.get(equalByteArray);
    }

    private static synchronized <V> void addToCache(Cache<Object, V> cache, byte[] byArray, V v) {
        if (byArray.length > 0x400000) {
            return;
        }
        Cache.EqualByteArray equalByteArray = new Cache.EqualByteArray(byArray);
        cache.put(equalByteArray, v);
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            byte[] byArray = X509Factory.readOneBlock(inputStream);
            if (byArray != null) {
                return new X509CertPath(new ByteArrayInputStream(byArray));
            }
            throw new IOException("Empty input");
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inputStream, String string) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            byte[] byArray = X509Factory.readOneBlock(inputStream);
            if (byArray != null) {
                return new X509CertPath(new ByteArrayInputStream(byArray), string);
            }
            throw new IOException("Empty input");
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    @Override
    public CertPath engineGenerateCertPath(List<? extends Certificate> list) throws CertificateException {
        return new X509CertPath(list);
    }

    @Override
    public Iterator<String> engineGetCertPathEncodings() {
        return X509CertPath.getEncodingsStatic();
    }

    @Override
    public Collection<? extends Certificate> engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            return this.parseX509orPKCS7Cert(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException);
        }
    }

    @Override
    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        if (inputStream == null) {
            crlCache.clear();
            throw new CRLException("Missing input stream");
        }
        try {
            byte[] byArray = X509Factory.readOneBlock(inputStream);
            if (byArray != null) {
                X509CRLImpl x509CRLImpl = X509Factory.getFromCache(crlCache, byArray);
                if (x509CRLImpl != null) {
                    return x509CRLImpl;
                }
                x509CRLImpl = new X509CRLImpl(byArray);
                X509Factory.addToCache(crlCache, x509CRLImpl.getEncodedInternal(), x509CRLImpl);
                return x509CRLImpl;
            }
            throw new IOException("Empty input");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.getMessage());
        }
    }

    @Override
    public Collection<? extends CRL> engineGenerateCRLs(InputStream inputStream) throws CRLException {
        if (inputStream == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            return this.parseX509orPKCS7CRL(inputStream);
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.getMessage());
        }
    }

    private Collection<? extends Certificate> parseX509orPKCS7Cert(InputStream inputStream) throws CertificateException, IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        ArrayList<X509CertImpl> arrayList = new ArrayList<X509CertImpl>();
        int n = pushbackInputStream.read();
        if (n == -1) {
            return new ArrayList(0);
        }
        pushbackInputStream.unread(n);
        byte[] byArray = X509Factory.readOneBlock(pushbackInputStream);
        if (byArray == null) {
            throw new CertificateException("No certificate data found");
        }
        try {
            PKCS7 pKCS7 = new PKCS7(byArray);
            X509Certificate[] x509CertificateArray = pKCS7.getCertificates();
            if (x509CertificateArray != null) {
                return Arrays.asList(x509CertificateArray);
            }
            return new ArrayList(0);
        }
        catch (ParsingException parsingException) {
            while (byArray != null) {
                arrayList.add(new X509CertImpl(byArray));
                byArray = X509Factory.readOneBlock(pushbackInputStream);
            }
            return arrayList;
        }
    }

    private Collection<? extends CRL> parseX509orPKCS7CRL(InputStream inputStream) throws CRLException, IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        ArrayList<X509CRLImpl> arrayList = new ArrayList<X509CRLImpl>();
        int n = pushbackInputStream.read();
        if (n == -1) {
            return new ArrayList(0);
        }
        pushbackInputStream.unread(n);
        byte[] byArray = X509Factory.readOneBlock(pushbackInputStream);
        if (byArray == null) {
            throw new CRLException("No CRL data found");
        }
        try {
            PKCS7 pKCS7 = new PKCS7(byArray);
            X509CRL[] x509CRLArray = pKCS7.getCRLs();
            if (x509CRLArray != null) {
                return Arrays.asList(x509CRLArray);
            }
            return new ArrayList(0);
        }
        catch (ParsingException parsingException) {
            while (byArray != null) {
                arrayList.add(new X509CRLImpl(byArray));
                byArray = X509Factory.readOneBlock(pushbackInputStream);
            }
            return arrayList;
        }
    }

    private static byte[] readOneBlock(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = inputStream.read();
        if (n5 == -1) {
            return null;
        }
        if (n5 == 48) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            byteArrayOutputStream.write(n5);
            X509Factory.readBERInternal(inputStream, byteArrayOutputStream, n5);
            return byteArrayOutputStream.toByteArray();
        }
        char[] cArray = new char[2048];
        int n6 = 0;
        int n7 = n5 == 45 ? 1 : 0;
        int n8 = n4 = n5 == 45 ? -1 : n5;
        do {
            if ((n3 = inputStream.read()) == -1) {
                return null;
            }
            if (n3 == 45) {
                ++n7;
                continue;
            }
            n7 = 0;
            n4 = n3;
        } while (n7 != 5 || n4 != -1 && n4 != 13 && n4 != 10);
        StringBuilder stringBuilder = new StringBuilder("-----");
        while (true) {
            if ((n2 = inputStream.read()) == -1) {
                throw new IOException("Incomplete data");
            }
            if (n2 == 10) {
                n3 = 10;
                break;
            }
            if (n2 == 13) {
                n2 = inputStream.read();
                if (n2 == -1) {
                    throw new IOException("Incomplete data");
                }
                if (n2 == 10) {
                    n3 = 10;
                    break;
                }
                n3 = 13;
                cArray[n6++] = (char)n2;
                break;
            }
            stringBuilder.append((char)n2);
        }
        while (true) {
            if ((n2 = inputStream.read()) == -1) {
                throw new IOException("Incomplete data");
            }
            if (n2 == 45) break;
            cArray[n6++] = (char)n2;
            if (n6 < cArray.length) continue;
            cArray = Arrays.copyOf(cArray, cArray.length + 1024);
        }
        StringBuilder stringBuilder2 = new StringBuilder("-");
        while ((n = inputStream.read()) != -1 && n != n3 && n != 10) {
            if (n == 13) continue;
            stringBuilder2.append((char)n);
        }
        X509Factory.checkHeaderFooter(stringBuilder.toString(), stringBuilder2.toString());
        return Pem.decode(new String(cArray, 0, n6));
    }

    private static void checkHeaderFooter(String string, String string2) throws IOException {
        String string3;
        if (string.length() < 16 || !string.startsWith("-----BEGIN ") || !string.endsWith("-----")) {
            throw new IOException("Illegal header: " + string);
        }
        if (string2.length() < 14 || !string2.startsWith("-----END ") || !string2.endsWith("-----")) {
            throw new IOException("Illegal footer: " + string2);
        }
        String string4 = string.substring(11, string.length() - 5);
        if (!string4.equals(string3 = string2.substring(9, string2.length() - 5))) {
            throw new IOException("Header and footer do not match: " + string + " " + string2);
        }
    }

    private static int readBERInternal(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, int n) throws IOException {
        int n2;
        if (n == -1) {
            n = inputStream.read();
            if (n == -1) {
                throw new IOException("BER/DER tag info absent");
            }
            if ((n & 0x1F) == 31) {
                throw new IOException("Multi octets tag not supported");
            }
            byteArrayOutputStream.write(n);
        }
        if ((n2 = inputStream.read()) == -1) {
            throw new IOException("BER/DER length info absent");
        }
        byteArrayOutputStream.write(n2);
        if (n2 == 128) {
            int n3;
            if ((n & 0x20) != 32) {
                throw new IOException("Non constructed encoding must have definite length");
            }
            while ((n3 = X509Factory.readBERInternal(inputStream, byteArrayOutputStream, -1)) != 0) {
            }
        } else {
            int n4;
            if (n2 < 128) {
                n4 = n2;
            } else if (n2 == 129) {
                n4 = inputStream.read();
                if (n4 == -1) {
                    throw new IOException("Incomplete BER/DER length info");
                }
                byteArrayOutputStream.write(n4);
            } else if (n2 == 130) {
                int n5 = inputStream.read();
                int n6 = inputStream.read();
                if (n6 == -1) {
                    throw new IOException("Incomplete BER/DER length info");
                }
                byteArrayOutputStream.write(n5);
                byteArrayOutputStream.write(n6);
                n4 = n5 << 8 | n6;
            } else if (n2 == 131) {
                int n7 = inputStream.read();
                int n8 = inputStream.read();
                int n9 = inputStream.read();
                if (n9 == -1) {
                    throw new IOException("Incomplete BER/DER length info");
                }
                byteArrayOutputStream.write(n7);
                byteArrayOutputStream.write(n8);
                byteArrayOutputStream.write(n9);
                n4 = n7 << 16 | n8 << 8 | n9;
            } else if (n2 == 132) {
                int n10 = inputStream.read();
                int n11 = inputStream.read();
                int n12 = inputStream.read();
                int n13 = inputStream.read();
                if (n13 == -1) {
                    throw new IOException("Incomplete BER/DER length info");
                }
                if (n10 > 127) {
                    throw new IOException("Invalid BER/DER data (a little huge?)");
                }
                byteArrayOutputStream.write(n10);
                byteArrayOutputStream.write(n11);
                byteArrayOutputStream.write(n12);
                byteArrayOutputStream.write(n13);
                n4 = n10 << 24 | n11 << 16 | n12 << 8 | n13;
            } else {
                throw new IOException("Invalid BER/DER data (too huge?)");
            }
            if (X509Factory.readFully(inputStream, byteArrayOutputStream, n4) != n4) {
                throw new IOException("Incomplete BER/DER data");
            }
        }
        return n;
    }

    private void recordEvent(X509CertImpl x509CertImpl) {
        if (EventHelper.isLoggingSecurity()) {
            PublicKey publicKey = x509CertImpl.getPublicKey();
            EventHelper.logX509CertificateEvent(x509CertImpl.getSigAlgName(), x509CertImpl.getSerialNumber().toString(16), x509CertImpl.getSubjectDN().getName(), x509CertImpl.getIssuerDN().getName(), publicKey.getAlgorithm(), KeyUtil.getKeySize(publicKey), x509CertImpl.hashCode(), x509CertImpl.getNotBefore().getTime(), x509CertImpl.getNotAfter().getTime());
        }
    }
}

