/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.MysqlxSession;
import com.mysql.cj.protocol.ColumnDefinition;
import com.mysql.cj.protocol.x.StatementExecuteOk;
import com.mysql.cj.result.RowList;
import com.mysql.cj.xdevapi.FilterableStatement;
import com.mysql.cj.xdevapi.FindParams;
import com.mysql.cj.xdevapi.RowResult;
import com.mysql.cj.xdevapi.RowResultImpl;
import com.mysql.cj.xdevapi.SelectStatement;
import com.mysql.cj.xdevapi.Statement;
import com.mysql.cj.xdevapi.TableFindParams;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class SelectStatementImpl
extends FilterableStatement<SelectStatement, RowResult>
implements SelectStatement {
    private MysqlxSession mysqlxSession;
    private FindParams findParams;

    SelectStatementImpl(MysqlxSession mysqlxSession, String schema, String table, String projection) {
        super(new TableFindParams(schema, table));
        this.findParams = (TableFindParams)this.filterParams;
        this.mysqlxSession = mysqlxSession;
        if (projection != null && projection.length() > 0) {
            this.findParams.setFields(projection);
        }
    }

    SelectStatementImpl(MysqlxSession mysqlxSession, String schema, String table, String ... projection) {
        super(new TableFindParams(schema, table));
        this.findParams = (TableFindParams)this.filterParams;
        this.mysqlxSession = mysqlxSession;
        if (projection != null && projection.length > 0) {
            this.findParams.setFields(projection);
        }
    }

    @Override
    public RowResultImpl execute() {
        return (RowResultImpl)this.mysqlxSession.find(this.findParams, metadata -> (rows, task) -> new RowResultImpl((ColumnDefinition)metadata, this.mysqlxSession.getServerSession().getDefaultTimeZone(), (RowList)rows, (Supplier<StatementExecuteOk>)task));
    }

    @Override
    public CompletableFuture<RowResult> executeAsync() {
        return this.mysqlxSession.asyncFind(this.findParams, metadata -> (rows, task) -> new RowResultImpl((ColumnDefinition)metadata, this.mysqlxSession.getServerSession().getDefaultTimeZone(), (RowList)rows, (Supplier<StatementExecuteOk>)task));
    }

    @Override
    public SelectStatement groupBy(String ... groupBy) {
        this.findParams.setGrouping(groupBy);
        return this;
    }

    @Override
    public SelectStatement having(String having) {
        this.findParams.setGroupingCriteria(having);
        return this;
    }

    @Override
    public FindParams getFindParams() {
        return this.findParams;
    }

    @Override
    public SelectStatement lockShared() {
        return this.lockShared(Statement.LockContention.DEFAULT);
    }

    @Override
    public SelectStatement lockShared(Statement.LockContention lockContention) {
        this.findParams.setLock(FindParams.RowLock.SHARED_LOCK);
        switch (lockContention) {
            case NOWAIT: {
                this.findParams.setLockOption(FindParams.RowLockOptions.NOWAIT);
                break;
            }
            case SKIP_LOCKED: {
                this.findParams.setLockOption(FindParams.RowLockOptions.SKIP_LOCKED);
                break;
            }
        }
        return this;
    }

    @Override
    public SelectStatement lockExclusive() {
        return this.lockExclusive(Statement.LockContention.DEFAULT);
    }

    @Override
    public SelectStatement lockExclusive(Statement.LockContention lockContention) {
        this.findParams.setLock(FindParams.RowLock.EXCLUSIVE_LOCK);
        switch (lockContention) {
            case NOWAIT: {
                this.findParams.setLockOption(FindParams.RowLockOptions.NOWAIT);
                break;
            }
            case SKIP_LOCKED: {
                this.findParams.setLockOption(FindParams.RowLockOptions.SKIP_LOCKED);
                break;
            }
        }
        return this;
    }
}

